<?php

$fecha_ini='2021-10-3'; // Fecha inicial de la incapacidad 
$fecha_fin='2021-10-25'; // Fecha inicial de la incapacidad 
$salario_minimo=908526;
$salario=1700000;
$dias_totales=30;

// Arreglos de los porcentajes que sera de la BD
$array_porc_incap = array(['id_porc_incap'=>"1", 'porc_incap' => "66.66", 'dias_incap'=> '90'],['id_porc_incap'=>"2", 'porc_incap' => "50", 'dias_incap'=> '180']);

// Funcion para calcular los días
// La clase DateTime de PHP para asignar fechas
// Para calcular la diferencia entre dos fechas utilizo DateTime::diff
$fn_dias_total_incap=function($fecha_ini, $fecha_fin){

    $inicial=explode("-",$fecha_ini);
	$final=explode("-",$fecha_fin);
    //días proporcionales del primer mes
	$dias_mes = cal_days_in_month(CAL_GREGORIAN, $inicial[1], $inicial[0]); // 31
	if($inicial[2]<$dias_mes) $contador=$dias_mes-$inicial[2]; 
    elseif($inicial[2]==$dias_mes) $contador=30;
    // Días del mes final de la incapacidad 
    $dias_mesF = cal_days_in_month(CAL_GREGORIAN, $final[1], $final[0]); // 31
    if($final[2]<$dias_mesF) $contador=$contador+$final[2];
    elseif($final[2]==$dias_mesF) $contador=30;
    // Identifico la cantidad de meses entre el intervalo
    $fechainicial = new DateTime($fecha_ini);     
    $fechafinal = new DateTime($fecha_fin);
    $diferencia = $fechainicial->diff($fechafinal);
    $meses = (( $diferencia->y * 12 ) + $diferencia->m)-1;
    // sumo el total de días
    $contador=$contador+($meses*30);

    return $contador;
};

// Obtenemos el porcentaje de la incapacidad
$fn_obtener_porcentaje = function($array_porc_incap, $dias_total_incap){
    for($fila=0; $fila<count($array_porc_incap); $fila++):
        $dias_arr = $dias_total_incap;

        if($fila==0){
            if($dias_arr >= 0 && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }else{
            $fila_antes=$fila-1;
            if($dias_arr >= $array_porc_incap[$fila_antes]["dias_incap"] && $dias_arr <= $array_porc_incap[$fila]["dias_incap"]){
                $factor = $array_porc_incap[$fila]["porc_incap"];      
            }
        }
         
    endfor;
    return $factor/100;
};

// Calculamos el valor con el salario minimo y los dias de incapacidad
$fn_valor_porc_minimo=function($dias_total_incap, $salario_minimo, $dias_totales){
    return round($valor_porc_minimo=($salario_minimo / $dias_totales) * $dias_total_incap);
};

// Calculammos el valor de la incapacidad comparando el porcentaje
// tengamos en cuenta que si el valor con el calculo del porcentaje es menor al valor del salario minimo, el valor se calcula con el 100%
function valor_pagar($fn_dias_total_incap, $fecha_ini, $fecha_fin, $fn_obtener_porcentaje, $array_porc_incap, $salario, $fn_valor_porc_minimo, $dias_totales, $salario_minimo){
    
    $dias=$fn_dias_total_incap($fecha_ini, $fecha_fin);
    $porcentaje=$fn_obtener_porcentaje($array_porc_incap, $dias);
    $valor_porc_minimo=$fn_valor_porc_minimo($dias, $salario_minimo, $dias_totales);

    $valor_dias_salario = ((($salario / $dias_totales) * $dias) * $porcentaje);
    if($valor_dias_salario <= $valor_porc_minimo) $valor_dias_salario = $valor_porc_minimo;
    return $valor_dias_salario;
};

valor_pagar($fn_dias_total_incap, $fecha_ini, $fecha_fin, $fn_obtener_porcentaje, $array_porc_incap, $salario, $fn_valor_porc_minimo, $dias_totales, $salario_minimo);




?>